<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RoleModel.php,v 1.1.2.5.2.1 2025/08/29 07:19:20 dgoron Exp $

namespace Pmb\Users\Models;

use Pmb\Common\Models\Model;
use Pmb\Users\Orm\RoleRightOrm;
use Pmb\Users\Orm\RoleMemberOrm;

class RoleModel extends Model
{
    protected $ormName = "Pmb\Users\Orm\RoleOrm";
    
    /**
     * 
     * @var string
     */
    public $name ='';
    
    /**
     *
     * @var string
     */
    public $comment ='';
    
    /**
     *
     * @var array
     */
    public $members = [];
    
    /**
     * 
     * @var object
     */
    public $rights;
    
    /**
     * Liste des cls de la proprit rights
     * @var array
     */
    public $rights_properties = ['modules', 'tabs', 'subTabs', 'actions'];
    
    protected static $instances = [];
    
    protected function fetchData()
    {
        parent::fetchData();
        $this->fetchMembers();
        $this->fetchRights();
    }
    
    public function fetchRights()
    {
        if (empty($this->rights)) {
            $this->rights = new \stdClass();
            $this->fetchRightsModules();
            $this->fetchRightsTabs();
            $this->fetchRightsSubTabs();
            $this->fetchRightsActions();
        }
    }
    
    protected function getInstanceRightModel($component, $module, $key='')
    {
        $roleRightModel = new RoleRightModel();
        $roleRightModel->component = $component;
        $roleRightModel->module = $module;
        if ($key) {
            $explodedKey = explode('/', $key);
            $roleRightModel->categ = $explodedKey[0];
            $roleRightModel->sub = $explodedKey[1];
            $roleRightModel->urlExtra = $explodedKey[2];
            if (!empty($explodedKey[3])) {
                $roleRightModel->action = $explodedKey[3];
            }
        }
        $roleRightModel->numRole = $this->id;
        return $roleRightModel;
    }
    
    public function setRightsPropertyFromForm(string $property, string $component, object $data)
    {
        foreach ($data as $moduleName=>$module) {
            if ($property == 'modules') {
                $roleRightModel = $this->getInstanceRightModel('module', $moduleName);
                $roleRightModel->setPropertiesFromForm($module);
                $this->rights->{$property}[] = $roleRightModel;
            } else {
                foreach ($module as $key=>$right) {
                    $roleRightModel = $this->getInstanceRightModel($component, $moduleName, $key);
                    $roleRightModel->setPropertiesFromForm($right);
                    $this->rights->{$property}[] = $roleRightModel;
                }
            }
        }
    }
    
    public function setPropertiesFromForm(object $data)
    {
        $this->name = $data->name;
        $this->comment = $data->comment;
        $this->members = [];
        if (!empty($data->members)) {
            foreach ($data->members as $typeMember=>$members) {
                foreach ($members as $numMember) {
                    $roleMemberModel = new RoleMemberModel();
                    $roleMemberModel->typeMember = $typeMember;
                    $roleMemberModel->numMember = $numMember;
                    $roleMemberModel->numRole = $this->id;
                    $this->members[] = $roleMemberModel;
                }
            }
        }
        $this->rights = new \stdClass();
        if (!empty($data->rights)) {
            foreach ($data->rights as $property=>$modules) {
                switch ($property) {
                    case 'modules':
                        $this->setRightsPropertyFromForm($property, 'module', $modules);
                        break;
                    case 'tabs':
                        $this->setRightsPropertyFromForm($property, 'tab', $modules);
                        break;
                    case 'subtabs':
                        $this->setRightsPropertyFromForm($property, 'subtab', $modules);
                        break;
                    case 'actions':
                        $this->setRightsPropertyFromForm($property, 'action', $modules);
                        break;
                }
            }
        }
    }
    
    public function save_rights()
    {
        foreach ($this->rights_properties as $property) {
            if (!empty($this->rights->{$property})) {
                foreach ($this->rights->{$property} as $rightModel) {
                    $rightModel->save();
                }
            }
        }
    }
    
    /**
     * Mise  jour des droits utilisateurs
     */
    public function save_members()
    {
        foreach ($this->members as $member) {
            if($member->typeMember == 'user') {
                $numRoles = $member->getNumRoles($member->numMember);
                if (!empty($numRoles)) {
                    $user = new \user($member->numMember);
                    $user->adjustment_rights_from_roles($numRoles);
                    $rights =intval($user->get_rights());
                    if ($rights) {
                        $query = "UPDATE users SET rights='".$rights."' WHERE userid=".$member->numMember;
                        pmb_mysql_query($query);
                    }
                }
            }
        }
    }
    
    public function save()
    {
        $orm = new $this->ormName($this->id);
        
        $orm->name = $this->name;
        $orm->comment = $this->comment;
        
        $orm->save();
        if(!$this->id) {
            $this->id = $orm->id;
        }
        
        // Suppression des lignes associes au rle
        $query = "DELETE FROM users_roles_members WHERE num_role = " . $this->id;
        pmb_mysql_query($query);
        
        foreach ($this->members as $member) {
            $member->save();
        }
        if (!empty($this->rights)) {
            $this->save_rights();
        }
        
        //Mise  jour des droits utilisateurs
        $this->save_members();
        
        return $orm;
    }
    
    public function delete()
    {
        //TODO : supprimer les entrees dans les autres tables 
        
        $orm = new $this->ormName($this->id);
        $orm->delete();
        return true;
    }
    
    public function fetchMembers()
    {
        if (empty($this->members)) {
            $members = RoleMemberOrm::finds(['num_role' => $this->id]);
            foreach ($members as $member) {
//                 $this->members[$member->type_member][$member->num_member] = [
//                     'visible' => 1
//                 ];
                $this->members[$member->type_member][] = $member->num_member;
            }
        }
    }
    
    public function getFormattedRightData($data)
    {
        return [
            'visible' => $data->visible,
            'privilege' => $data->privilege,
            'log' => $data->log,
        ];
    }
    
    public function fetchRightsModules()
    {
        if (empty($this->rights->modules)) {
            $modules = RoleRightOrm::finds(['num_role' => $this->id, 'component' => 'module']);
            if (!empty($modules)) {
                $this->rights->modules = [];
                foreach ($modules as $module) {
                    $this->rights->modules[$module->module] = $this->getFormattedRightData($module);
                }
            } else {
                $this->rights->modules = new \stdClass();
            }
        }
    }
    
    public function fetchRightsTabs()
    {
        if (empty($this->rights->tabs)) {
            $tabs = RoleRightOrm::finds(['num_role' => $this->id, 'component' => 'tab']);
            if (!empty($tabs)) {
                $this->rights->tabs = [];
                foreach ($tabs as $tab) {
                    $tabKey = $tab->categ.'/'.$tab->sub.'/'.$tab->url_extra;
                    $this->rights->tabs[$tab->module][$tabKey] = $this->getFormattedRightData($tab);
                }
            } else {
                $this->rights->tabs = new \stdClass();
            }
        }
    }
    
    public function fetchRightsSubTabs()
    {
        if (empty($this->rights->subTabs)) {
            $subTabs = RoleRightOrm::finds(['num_role' => $this->id, 'component' => 'subtab']);
            if (!empty($subTabs)) {
                $this->rights->subTabs = [];
                foreach ($subTabs as $subTab) {
                    $subTabKey = $subTab->categ.'/'.$subTab->sub.'/'.$subTab->url_extra;
                    $this->rights->subTabs[$subTab->module][$subTabKey] = $this->getFormattedRightData($subTab);
                }
            } else {
                $this->rights->subTabs = new \stdClass();
            }
        }
    }
    
    public function fetchRightsActions()
    {
        if (empty($this->rights->actions)) {
            $actions = RoleRightOrm::finds(['num_role' => $this->id, 'component' => 'action']);
            if (!empty($actions)) {
                $this->rights->actions = [];
                foreach ($actions as $action) {
                    $actionKey = $action->categ.'/'.$action->sub.'/'.$action->url_extra.'/'.$action->action;
                    $this->rights->actions[$action->module][$actionKey] = $this->getFormattedRightData($action);
                }
            } else {
                $this->rights->actions = new \stdClass();
            }
        }
    }
    
    public static function getInstance($id)
    {
        $id = intval($id);
        if(!isset(static::$instances[$id])) {
            static::$instances[$id] = new RoleModel($id);
        }
        return static::$instances[$id];
    }
}
