// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: urlDialog.js,v 1.2 2015/10/29 09:47:14 ngantier Exp $

define(["dojo/_base/declare", "dojo/topic", "dojo/_base/lang", "dojo/dom-construct", "dojo/dom", "dojox/validate/regexp", "dijit/Dialog",  "dijit/form/TextBox", "dijit/form/Button", "dojo/on", "dojo/Deferred", "dojo/request/xhr"], function(declare, topic, lang, domConstruct, dom, regexp, Dialog,  TextBox, Button, on, Deferred, xhr) {
    return declare(null, {
        dialog : null,
        form : null,
        textBox : null,
        validateButton : null,
        finalValue : "",
        deferred : null,
        message : "",
        constructor : function(message) {
            /**
             * Instanciation ddu dialog, de la textbox, du regexp url
             */
            if (message) {
                this.message = message;
            }
            this.deferred = new Deferred();
            this.instanciateDialog();
            return this.deferred.promise;
        },
        
        /** Méthode d'instanciation de la popup **/
        instanciateDialog : function() {
            this.textBox = new TextBox({
                placeHolder : "Url du webservice",
                id : 'textBoxUrl',
                style: {display:'block', margin:'0 1em 0 1em', width:'auto'}
                
            });
            
            this.dialog = new Dialog({
                content : this.textBox,
                title : "Entrez l\'url du connecteur",
            });
            
            /** Permet de désactiver la touche escape pour ne pas fermer le dialog **/
            this.dialog._onKey = function() { };
            
            if (this.message) {
                domConstruct.create('div', {id:'parametersMessage', style:{textAlign:'center', marginBottom:'10px'}, innerHTML:"<h3>" + this.message + "</h3>"}, this.dialog.containerNode);
            }

            this.textBox.placeAt(this.dialog.containerNode);
            this.textBox.startup();
            on(this.textBox, 'keyup', lang.hitch(this, this.checkTextBoxValue));
            this.dialog.show();
            this.dialog.closeButtonNode.style.display = "none";
        },
        
        /** Méthode vérifiant l'url; si elle est valide; le bouton valider apparait' **/
        checkTextBoxValue : function() {
            if (this.textBox.getValue().match(regexp.url())) {
                if (!this.validateButton) {
                    this.validateButton = new Button({
                        label : 'Valider',
                        onClick : lang.hitch(this, this.closePopup)
                    });
                    this.validateButton.placeAt(this.dialog.containerNode);
                }
            }else{
                if(this.validateButton){
                    this.validateButton.destroy();
                    this.validateButton = null;
                }
            }
        },
        
        /** Méthode de fermeture du popup, renvoi l'objet déférré initial; détruit les widgets; stocke la valeur entrée dans le sotckage local **/
        closePopup : function() {
            this.finalValue = this.textBox.getValue();
            this.textBox.destroy();
            this.validateButton.destroy();
            this.dialog.destroy();
            biblotoConnectorUrl = this.finalValue;
            this.deferred.resolve();
        },
    });
});
