// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: printerConfig.js,v 1.2 2022/05/12 07:59:35 qvarin Exp $

define([
	'dojo/_base/declare',
	'dijit/_Widget',
	'dojo/_base/lang',
	"dojo/dom-construct",
	"dojo/dom",
	"dojo/on"
], function(declare, widget, lang, domConstruct, dom, on) {
	return declare(widget, {
		printerList: null,
		printer: null,
		code: "",
		postCreate: function() {
			//On ne rentre que si le paramètre imprimante est activé
			if (dojoConfig.bibloto.appParams.printer_activate && (parseInt(dojoConfig.bibloto.appParams.printer_activate) > 0)) {
				this.getConfig();
			}
		},

		getConfig: function() {
			//On récupère et on set la config si disponible, sinon on génère le formulaire
			if (localStorage.getItem('printerConfig')) {
				this.config = localStorage.getItem('printerConfig');
				this.setPrinterId();
			} else {
				var home = dom.byId("home-page");
				home.style.display = 'none';
				this.domNode.style.display = '';
				this.initConfig();
			}
		},
		initConfig: function() {
			//On récupère la liste des imprimantes via le webservice;
			dojoConfig.bibloto.jsonRpcServer.pmbesSelfServices_get_printers_config().then((config) => {
				this.printer = config.printer_name;
				this.printerList = config.printer_list;
				this.generateForm();
			});
		},
		generateForm: function() {
			//Génération des éléments du formulaire
			domConstruct.create('div', { id: `configContent`, class: 'configContent' }, "config");
			domConstruct.create('h1', { id: `printerConfigTitle`, innerHTML: dojoConfig.bibloto.appParams.msg_config_printer_title }, "configContent");
			domConstruct.create('div', { id: `printerFormContainer`, class: 'printerFormContainer' }, "configContent");
			domConstruct.create('select', { id: `printerConfigSelector`, name: 'printerConfigSelector', class: 'printerConfigSelector' }, "printerFormContainer");
			for (let i in this.printerList) {
				domConstruct.create('option', { id: `PrinterConfig_${i}`, name: `PrinterConfig_${i}`, value: this.printerList[i], innerHTML: this.printerList[i] }, "printerConfigSelector");
			}
			domConstruct.create('option', { id: `PrinterConfigDefault`, name: `PrinterConfigDefault`, value: "none", innerHTML: dojoConfig.bibloto.appParams.msg_config_printer_no_printer }, "printerConfigSelector");

			//Bouton de validation
			var validate = domConstruct.create('input', {
				type: "button",
				value: dojoConfig.bibloto.appParams.msg_config_printer_validate,
				className: 'validateConfigButton'
			});
			domConstruct.place(validate, 'printerFormContainer');
			on(validate, 'click', lang.hitch(this, this.storeConfig));
		},
		storeConfig: function() {
			var value = 'none';
			var selector = document.getElementsByName('printerConfigSelector');
			if (selector.length) {
				value = selector[0].value;
			}
			//On set dans le localStorage et on remet l'écran d'accueil
			localStorage.setItem('printerConfig', value);
			this.config = value;
			this.setPrinterId();
			
			this.domNode.style.display = 'none';
			var home = dom.byId("home-page");
			home.style.display = '';
		},
		//Insertion de l'identifiant de l'imprimante à utiliser dans dojoConfig à partir de la config'
		setPrinterId: function() {
			if (this.config && this.config != 'none') {
				try {
					var temp = this.config.split('_');
					dojoConfig.printer_id = parseInt(temp[0].trim());
				} catch (e) {
					console.error("wrong printer name format");
				}
			};
		}
	});
});