// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: keyboard.js,v 1.19 2024/07/26 09:01:00 tsamson Exp $

require(["dojo/on", "dojo/topic", "dojo/_base/lang", "dojo/domReady!"], function(on, topic, lang) { 
	on(document, "keypress", function(event) {
		var visible_input = document.getElementById('visible_input');
		var visible_input_value = '';
		if (visible_input) {
			visible_input_value = visible_input.value;
		}
		var extAuthButton = document.getElementById('ext_auth_button');
        switch(event.key) {
        case "Enter":
            var cb = new Array();
            keyboard_cb_enter = this.cb;
            cb[0] = this.cb;
			if (visible_input_value){
				cb[0] = visible_input.value;
			}
            if (this.cb || (visible_input_value)) {
                topic.publish('keyboard', "cbReady", {
                    'cb' : cb
                });
                dojoConfig.bibloto.appParams.rfid_lastVal = this.cb;
                dojoConfig.bibloto.buffer.addElt(cb);
            }
            if (extAuthButton && !this.cb && !visible_input_value) {
				extAuthButton.click();
			}
            this.cb = "";
			if (visible_input) {
				visible_input.value = '';
			}
            document.getElementById('keyboard').value = '';
        	if(this.timer){
        		clearTimeout(this.timer);
                this.timer = null;
        	}
            break;
        case "Tab":
        case "ArrowUp":
        case "ArrowUpArrowDown":
        case "ArrowLeft":
        case "ArrowRight":
        case "Enter":
        case "Escape":
        	this.cb = "";  
            document.getElementById('keyboard').value = '';
            break;
        default:
        	if(this.timer){
        		clearTimeout(this.timer);
                this.timer = null;
        	}
            this.timer = setTimeout(lang.hitch(this, function() {
                this.cb = "";
                document.getElementById('keyboard').value = '';
            }), 3000);
            if (!this.cb)
                this.cb = "";
            
            this.cb += event.key;
        }
    });
});
